DROP DATABASE IF EXISTS poslaju_sla;
CREATE DATABASE poslaju_sla;
USE poslaju_sla;

-- Table: postcode
CREATE TABLE postcode (
    id INT AUTO_INCREMENT PRIMARY KEY,
    state VARCHAR(100) NOT NULL,
    city VARCHAR(100) NOT NULL,
    postcode VARCHAR(10) NOT NULL,
    zone VARCHAR(20) NOT NULL,
    sla_min_days INT NOT NULL,
    sla_max_days INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    
    INDEX idx_postcode (postcode)
) ENGINE=InnoDB;

-- Table: tracking
CREATE TABLE tracking (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tracking_no VARCHAR(50) NOT NULL,
    postcode_id INT NOT NULL,
    ship_date DATE,
    zone VARCHAR(20),
    sla_min_days INT,
    sla_max_days INT,
    est_deadline DATE,
    current_status VARCHAR(255),
    delivered_date DATE,
    sla_compliance VARCHAR(20),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    upload_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,

    UNIQUE KEY (tracking_no),
    INDEX idx_ship_date (ship_date),

    FOREIGN KEY (postcode_id) REFERENCES postcode(id)
) ENGINE=InnoDB;



CREATE TABLE IF NOT EXISTS admin_users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(150) UNIQUE NOT NULL,
    role ENUM('staff', 'manager', 'admin') DEFAULT 'staff',
    status ENUM('active', 'inactive', 'suspended') DEFAULT 'active',
    last_login DATETIME NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    INDEX idx_username (username),
    INDEX idx_email (email),
    INDEX idx_status (status),
    INDEX idx_role (role)
);




INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50088', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50250', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50350', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50420', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50450', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50460', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50470', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50480', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50489', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50490', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50502', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50504', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50505', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50506', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50507', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50508', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50512', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50514', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50515', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50519', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50528', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50529', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50530', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50532', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50534', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50536', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50538', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50540', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50544', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50546', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50548', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50550', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50551', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50552', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50554', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50556', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50560', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50562', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50564', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50566', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50568', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50572', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50576', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50578', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50580', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50582', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50586', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50588', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50590', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50592', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50594', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50596', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50598', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50599', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50603', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50604', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50605', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50608', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50609', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50610', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50612', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50614', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50620', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50621', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50622', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50623', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50626', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50630', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50632', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50634', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50636', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50638', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50640', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50642', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50644', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50646', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50648', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50650', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50652', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50653', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50656', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50658', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50660', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50661', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50662', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50664', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50666', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50668', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50670', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50672', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50673', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50674', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50676', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50677', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50678', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50680', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50682', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50684', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50688', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50694', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50702', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50704', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50706', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50708', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50710', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50712', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50714', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50716', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50718', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50720', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50722', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50724', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50726', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50728', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50730', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50732', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50734', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50736', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50738', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50740', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50742', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50744', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50746', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50748', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50750', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50752', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50754', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50758', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50760', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50762', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50764', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50766', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50768', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50770', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50772', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50774', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50776', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50778', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50780', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50782', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50784', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50786', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50788', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50790', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50792', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50794', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50796', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50798', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50802', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50804', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50806', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50808', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50810', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50812', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50814', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50816', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50818', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50901', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50902', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50903', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50904', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50906', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50907', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50908', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50909', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50910', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50911', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50912', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50913', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50914', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50915', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50916', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50917', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50918', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50919', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50920', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50921', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50922', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50923', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50924', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50925', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50926', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50927', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50928', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50929', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50930', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50931', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50932', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50933', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50934', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50935', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50936', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50937', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50938', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50939', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50940', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50941', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50942', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50943', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50944', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50945', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50946', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50947', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50948', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50949', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50950', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50988', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50989', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '50990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51640', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '51990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52109', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52210', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '52220', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '53990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '54000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '54050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '54100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '54200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '54540', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55188', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55220', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55330', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55710', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55720', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55902', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55904', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55906', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55908', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55910', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55912', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55914', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55916', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55918', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55920', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55922', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55924', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55926', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55928', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55930', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55932', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55934', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '55990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '56000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '56100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '57000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '57100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '57200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '57700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '57990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58209', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '58990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59001', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59206', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '59990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Kuala Lumpur', '60000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Kuala Lumpur', 'Setapak', '53300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Ayer Baloi', '82100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Ayer Hitam', '86100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Ayer Tawar 2', '81920', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bandar Penawar', '81930', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bandar Penawar', '81960', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bandar Tenggara', '81440', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Anam', '85100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '83050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Batu Pahat', '86400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bekok', '86500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Benut', '82200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bukit Gambir', '84800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Bukit Pasir', '84300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Chaah', '85400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Endau', '86900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Endau', '86999', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Gelang Patah', '81550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Gelang Patah', '81560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Gerisek', '84700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Gerisek', '84710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Gugusan Taib Andak', '81450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Jementah', '85200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Jementah', '85210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80519', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80529', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80530', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80542', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80568', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80584', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80668', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80902', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80904', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80906', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80908', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80988', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '80990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Johor Bahru', '81310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kahang', '86700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kluang', '86000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kluang', '86007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kota Tinggi', '81900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kota Tinggi', '81907', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kota Tinggi', '81910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kukup', '82300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Kulai', '81050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Labis', '85300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Layang-Layang', '81850', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Masai', '81750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Masai', '81760', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Mersing', '86800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Mersing', '86810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Muar', '84410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79511', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79513', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79521', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79523', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79555', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79575', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79601', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79603', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79605', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79681', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Iskandar Puteri', '79683', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pagoh', '84600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Paloh', '86600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Panchor', '84500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Parit Jawa', '84150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Parit Jawa', '84160', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Parit Raja', '86400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Parit Sulong', '83500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pasir Gudang', '81700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pekan Nenas', '81500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pengerang', '81600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pengerang', '81620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pengerang', '81650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pontian', '82000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pontian', '82010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pontian', '82020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Pontian', '82030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Rengam', '86300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Rengit', '83100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Segamat', '85080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Semerah', '83600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Semerah', '83610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Senai', '81400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Senai', '81410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Senggarang', '83200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Seri Gading', '83300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Seri Medan', '83400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Simpang Rengam', '86200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Sungai Mati', '84400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Sungai Mati', '84409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Tangkak', '84900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Tangkak', '84990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Tioman', '86800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Ulu Tiram', '81800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Ulu Tiram', '81810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Yong Peng', '83700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Johor', 'Yong Peng', '83710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05460', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05580', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05621', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05675', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05696', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '05990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '06250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '06509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '06550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '06570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Alor Setar', '06660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Ayer Hitam', '06150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Baling', '09100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bandar Baharu', '34950', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bandar Bahru', '14290', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bandar Bahru', '14390', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bedong', '08100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bedong', '08110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Bukit Kayu Hitam', '06050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Changloon', '06010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Gurun', '08300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Gurun', '08330', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Gurun', '08800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Jeniang', '08320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Jeniang', '08700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Jitra', '06000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Jitra', '06007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Jitra', '06009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Karangan', '09700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kepala Batas', '06200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kepala Batas', '06207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kepala Batas', '06209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kodiang', '06100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kota Kuala Muda', '08500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kota Kuala Muda', '08507', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kota Kuala Muda', '08509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kota Sarang Semut', '06800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kuala Kedah', '06600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kuala Ketil', '09300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kuala Ketil', '09310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kuala Nerang', '06300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kuala Pegang', '09110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kulim', '09000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kulim', '09007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kulim', '09009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kulim', '09010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kulim', '09020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Kupang', '09200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langgar', '06500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langgar', '06507', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langkawi', '07000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langkawi', '07007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langkawi', '07009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Langkawi', '07100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Lunas', '09600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Merbok', '08400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Merbok', '08407', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Merbok', '08409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Padang Serai', '09400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Padang Serai', '09410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06707', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06709', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pendang', '06760', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pokok Sena', '06350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Pokok Sena', '06400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Serdang', '09800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Serdang', '09810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sik', '08200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sik', '08210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sik', '08340', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Simpang Empat', '06650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Simpang Empat', '06680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sungai Petani', '08000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sungai Petani', '08007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sungai Petani', '08009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sungai Petani', '08010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Sungai Petani', '08600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Yan', '06900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kedah', 'Yan', '06910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Ayer Lanas', '17700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16090', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16370', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Bachok', '16390', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Cherang Ruku', '16700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Dabong', '18200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Gua Musang', '18300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Jeli', '17600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kem Desa Pahlawan', '16500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Ketereh', '16450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15159', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15160', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15519', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15524', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15529', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15572', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15616', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15623', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15624', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15634', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15988', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '15990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '16010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '16100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '16109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kota Bharu', '16150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kuala Balah', '17610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kuala Krai', '18000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kuala Krai', '18020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Kuala Krai', '18050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Machang', '18500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Melor', '16400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Mas', '17070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pasir Puteh', '16800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Pulai Chondong', '16600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Rantau Panjang', '17200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Selising', '16810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17507', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17510', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tanah Merah', '17599', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Temangan', '18400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tumpat', '16080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tumpat', '16200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Tumpat', '16210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Wakaf Bharu', '16040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Wakaf Bharu', '16250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Kelantan', 'Wakaf Bharu', '16266', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Alor Gajah', '78000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Alor Gajah', '78009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Asahan', '77100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Asahan', '77109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Ayer Keroh', '75450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Bemban', '77200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Durian Tunggal', '76100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Durian Tunggal', '76109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Jasin', '77000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Jasin', '77007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Jasin', '77008', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Jasin', '77009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Kem Trendak', '76200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Kuala Sungai Baru', '78200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Lubok China', '78100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Masjid Tanah', '78300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Masjid Tanah', '78307', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Masjid Tanah', '78309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75260', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75430', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '75460', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Melaka', '76450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Merlimau', '77300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Selandar', '77500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Sungai Rambai', '77400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Sungai Udang', '76300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Tanjong Kling', '76400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Melaka', 'Tanjong Kling', '76409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bahau', '72100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bahau', '72107', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bahau', '72109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bandar Baru Enstek', '71760', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bandar Seri Jempol', '72120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bandar Seri Jempol', '72127', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Bandar Seri Jempol', '72129', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Batu Kikir', '72200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Batu Kikir', '72207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Batu Kikir', '72209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemas', '73400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemas', '73409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemas', '73410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemas', '73420', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemas', '73480', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemencheh', '73200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemencheh', '73207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemencheh', '73209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemencheh', '73300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Gemencheh', '73309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Johol', '73100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Johol', '73109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kota', '71350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kota', '71359', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Klawang', '71600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Klawang', '71609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Klawang', '71650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Klawang', '71659', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72507', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Kuala Pilah', '72509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Labu', '71900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Labu', '71907', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Labu', '71909', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Linggi', '71150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Linggi', '71159', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Mantin', '71700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Mantin', '71707', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Mantin', '71709', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Mantin', '71750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Mantin', '71759', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Nilai', '71800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Nilai', '71807', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Nilai', '71809', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Nilai', '71850', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71960', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Port Dickson', '71999', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Pusat Bandar Palong', '73430', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Pusat Bandar Palong', '73440', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Pusat Bandar Palong', '73450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Pusat Bandar Palong', '73460', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Pusat Bandar Palong', '73470', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rantau', '71100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rantau', '71109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rantau', '71200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rantau', '71209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rembau', '71300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rembau', '71309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rembau', '71400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rembau', '71409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rompin', '73500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rompin', '73507', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Rompin', '73509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70572', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70634', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '70990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '71450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '71459', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '71770', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Seremban', '71950', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Simpang Durian', '72400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Simpang Durian', '72409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Simpang Pertang', '72300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Simpang Pertang', '72307', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Simpang Pertang', '72309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Si Rusa', '71050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Si Rusa', '71059', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Si Rusa', '71250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Si Rusa', '71259', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tampin', '73000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tampin', '73007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tampin', '73009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tanjong Ipoh', '71500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tanjong Ipoh', '71509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tanjong Ipoh', '71550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Negeri Sembilan', 'Tanjong Ipoh', '71559', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Balok', '26080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Balok', '26100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Balok', '26150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Balok', '26190', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26420', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26430', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26440', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26460', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26485', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '26490', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Pusat Jengka', '27080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Tun Abdul Razak', '26900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bandar Tun Abdul Razak', '26999', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Benta', '27300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Benta', '27310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28707', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28709', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bentong', '28750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Brinchang', '39100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bukit Fraser', '49000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bukit Goh', '26050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Bukit Goh', '26090', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Chenor', '28100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Chini', '26690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Damak', '27030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Dong', '27400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26330', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26340', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26360', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Gambang', '26370', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Genting Highlands', '69000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jaya Gading', '26250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27090', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Jerantut', '27150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Karak', '28600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Karak', '28610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Karak', '28620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kemayan', '28340', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kemayan', '28380', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Krau', '28050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Lipis', '27200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Lipis', '27207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Lipis', '27209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Lipis', '27210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Rompin', '26800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Rompin', '26810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuala Rompin', '26820', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25509', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25524', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25529', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25584', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25598', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25656', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '25990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26140', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Kuantan', '26180', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Lanchang', '28500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Lurah Bilut', '28800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Maran', '26500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Mentakab', '28400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Mentakab', '28407', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Mentakab', '28409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Muadzam Shah', '26700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Padang Tengku', '27100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26607', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26640', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Pekan', '26680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27607', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Raub', '27670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Ringlet', '39200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Sega', '27660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Sungai Koyan', '27650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Sungai Lembing', '26200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Sungai Ruan', '27500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Tanah Rata', '39000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Tanah Rata', '39007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Tanah Rata', '39009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Tanah Rata', '39010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Temerloh', '28040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28330', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pahang', 'Triang', '28350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Ayer Itam', '11500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Balik Pulau', '11000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Balik Pulau', '11010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Balik Pulau', '11020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Batu Ferringhi', '11100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Batu Maung', '11960', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bayan Lepas', '11900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bayan Lepas', '11910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bayan Lepas', '11920', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bayan Lepas', '11950', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bukit Mertajam', '14000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bukit Mertajam', '14007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bukit Mertajam', '14009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Bukit Mertajam', '14020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '12990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Butterworth', '13800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Gelugor', '11700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Jelutong', '11600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Jelutong', '11609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Kepala Batas', '13200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Kepala Batas', '13210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Kepala Batas', '13220', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Kubang Semang', '14400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Nibong Tebal', '14300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Nibong Tebal', '14310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Nibong Tebal', '14320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Penaga', '13100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Penaga', '13110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Penang Hill', '11300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Perai', '13600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Perai', '13700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Permatang Pauh', '13500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10460', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10470', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10524', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10542', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10558', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10566', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10593', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10634', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10760', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10770', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10780', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10790', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10820', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10830', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10840', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10850', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10920', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '10990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '11050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '11060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '11400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Pulau Pinang', '11409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Simpang Ampat', '14100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Simpang Ampat', '14101', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Simpang Ampat', '14110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Simpang Ampat', '14120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Sungai Jawi', '14200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Tanjong Bungah', '11200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Tasek Gelugor', '13300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Tasek Gelugor', '13310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Pulau Pinang', 'Usm Pulau Pinang', '11800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ayer Tawar', '32400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bagan Datoh', '36100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bagan Serai', '34300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bagan Serai', '34310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bandar Seri Iskandar', '32610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Gajah', '31000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Gajah', '31007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Gajah', '31009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Kurau', '34500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Kurau', '34510', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Batu Kurau', '34520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Behrang Stesen', '35950', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bidor', '35500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bota', '32600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Bruas', '32700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Changkat Jering', '34850', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Changkat Keruing', '32500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Chemor', '31200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Chenderiang', '35300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Chenderong Balai', '36600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Chikus', '36750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Enggor', '33600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Gerik', '33300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Gerik', '33310', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Gerik', '33320', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Gopeng', '31600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Gopeng', '31610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Hutan Melintang', '36400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Intan', '33200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30205', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30510', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30519', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30524', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30542', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30554', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30580', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30621', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30634', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30656', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30668', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30682', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30730', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30740', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30760', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30770', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30780', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30790', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30820', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30830', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30840', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30902', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30904', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30906', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30908', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30912', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30988', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '30990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31407', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31409', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ipoh', '31672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Jeram', '31850', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31907', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31909', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31920', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampar', '31950', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampung Gajah', '36800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampung Gajah', '36810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kampung Kepayang', '31300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kamunting', '34600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kangsar', '33040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Kurau', '34350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Kuala Sepetang', '34650', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lambor Kanan', '32900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lambor Kanan', '32999', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Langkap', '36700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lenggong', '33400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lenggong', '33410', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lenggong', '33420', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Lumut', '32200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Malim Nawar', '31700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Manong', '33800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Matang', '34750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Padang Rengas', '33700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pangkor', '32300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pantai Remis', '34900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pantai Remis', '34910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Parit', '32800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Parit', '32810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Parit Buntar', '34200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pengkalan Hulu', '33100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pusing', '31550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Pusing', '31560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Rantau Panjang', '34140', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sauk', '33500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selama', '34100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selama', '34120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selama', '34130', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selekoh', '36200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selekoh', '36207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Selekoh', '36209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Seri Manjung', '32040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Seri Manjung', '32050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Simpang', '34700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Simpang Ampat Semanggol', '34400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sitiawan', '32000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sitiawan', '32010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sitiawan', '32020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Slim River', '35800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Slim River', '35820', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Siput', '31050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Siput', '31100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Siput', '31120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Sumun', '36300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Sumun', '36307', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungai Sumun', '36309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Sungkai', '35600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34008', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Taiping', '34030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Malim', '35900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Malim', '35907', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Malim', '35909', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Malim', '35910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Piandang', '34250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Rambutan', '31250', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tanjong Tualang', '31800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tapah', '35000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tapah', '35007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tapah', '35009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tapah Road', '35400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36008', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Teluk Intan', '36110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Temoh', '35350', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'TLDM Lumut', '32100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Trolak', '35700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Trong', '34800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Tronoh', '31750', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ulu Bernam', '36500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ulu Kinta', '31150', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perak', 'Ulu Kinta', '31199', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Arau', '02600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Arau', '02607', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Arau', '02609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kaki Bukit', '02200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01524', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01529', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01572', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01594', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01598', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01634', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01644', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '01694', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '02400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '02450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kangar', '02500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Kuala Perlis', '02000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Padang Besar', '02100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Simpang Ampat', '02700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Simpang Ampat', '02707', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Simpang Ampat', '02709', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Perlis', 'Simpang Ampat', '02800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beaufort', '89800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beaufort', '89807', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beaufort', '89808', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beaufort', '89809', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beluran', '90100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beluran', '90107', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beluran', '90109', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beverly', '88700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Beverly', '89260', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Bongawan', '89700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Bongawan', '89707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Bongawan', '89708', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Bongawan', '89709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Inanam', '88857', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Keningau', '89000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Keningau', '89007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Keningau', '89008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Keningau', '89009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Belud', '89150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Belud', '89157', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Belud', '89158', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Belud', '89159', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88110', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88220', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88400', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88450', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88458', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88460', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88502', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88504', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88505', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88506', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88508', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88510', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88512', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88514', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88516', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88518', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88520', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88526', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88527', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88532', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88534', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88538', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88540', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88546', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88550', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88551', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88552', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88554', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88556', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88558', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88560', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88562', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88564', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88566', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88568', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88570', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88572', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88576', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88580', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88582', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88586', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88590', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88592', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88594', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88596', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88598', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88602', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88604', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88606', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88608', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88609', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88610', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88612', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88614', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88617', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88618', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88620', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88621', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88622', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88624', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88626', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88628', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88630', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88632', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88634', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88644', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88646', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88648', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88656', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88658', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88660', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88661', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88662', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88670', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88672', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88673', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88675', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88676', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88680', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88690', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88740', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88757', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88758', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88759', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88760', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88761', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88762', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88763', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88764', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88765', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88766', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88767', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88768', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88769', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88770', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88771', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88772', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88773', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88774', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88775', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88776', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88777', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88778', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88779', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88780', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88781', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88782', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88783', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88784', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88785', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88786', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88787', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88788', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88789', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88790', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88801', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88802', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88803', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88804', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88805', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88806', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88807', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88808', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88809', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88810', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88811', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88812', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88813', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88814', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88815', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88816', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88817', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88818', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88819', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88820', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88821', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88822', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88823', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88824', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88825', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88826', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88827', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88828', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88829', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88830', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88831', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88832', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88833', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88834', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88835', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88836', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88837', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88838', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88839', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88840', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88841', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88842', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88843', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88844', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88845', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88846', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88847', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88848', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88849', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88850', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88851', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88852', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88853', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88854', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88855', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88860', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88861', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88862', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88863', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88865', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88866', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88867', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88868', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88869', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88870', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88871', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88872', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88873', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88874', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88875', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88901', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88902', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88903', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88904', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88905', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88906', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88988', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88990', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88991', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88992', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88993', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88994', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88995', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88996', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88997', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88998', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabalu', '88999', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Kinabatangan', '90200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Marudu', '89100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Marudu', '89107', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Marudu', '89108', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kota Marudu', '89109', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kuala Penyu', '89740', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kuala Penyu', '89747', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kuala Penyu', '89748', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kuala Penyu', '89749', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kudat', '89050', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kudat', '89057', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kudat', '89058', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kudat', '89059', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kunak', '91200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kunak', '91207', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Kunak', '91209', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91108', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91109', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91110', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91111', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91112', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91113', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91114', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91115', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91116', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91117', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91118', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91119', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91120', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91121', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91122', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91123', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91124', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91125', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91126', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91127', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91128', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Lahad Datu', '91150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Likas', '88856', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Membakut', '89720', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Membakut', '89727', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Membakut', '89728', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Membakut', '89729', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Menumbok', '89760', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Menumbok', '89767', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Menumbok', '89768', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Menumbok', '89769', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Nabawan', '89950', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Nabawan', '89957', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Nabawan', '89958', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Nabawan', '89959', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Pamol', '90400', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Papar', '89600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Papar', '89607', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Papar', '89608', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Papar', '89609', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Penampang', '89500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Penampang', '89507', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Penampang', '89508', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Penampang', '89509', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Putatan', '88721', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Putatan', '88722', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Putatan', '88723', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Putatan', '88724', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Putatan', '88725', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89307', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89308', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89309', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89320', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89350', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Ranau', '89357', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90307', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90701', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90702', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90703', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90704', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90705', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90706', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90708', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90711', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90712', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90713', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90714', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90715', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90716', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90717', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90718', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90719', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90720', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90721', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90722', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90723', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90724', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90725', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90726', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90727', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90728', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90729', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90730', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90731', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90732', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90733', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90734', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90735', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90736', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90737', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90738', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90739', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90740', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sandakan', '90741', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Semporna', '91300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Semporna', '91307', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Semporna', '91308', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Semporna', '91309', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sipitang', '89850', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sipitang', '89857', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sipitang', '89858', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Sipitang', '89859', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tambunan', '89650', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tambunan', '89657', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tambunan', '89658', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tambunan', '89659', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tamparuli', '89250', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tamparuli', '89257', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tamparuli', '89258', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tamparuli', '89259', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tanjung Aru', '88858', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tenghilan', '89260', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91010', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91011', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91012', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91013', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91014', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91015', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91016', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91017', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91018', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91019', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91020', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91021', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91022', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91023', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91024', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91025', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91026', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91027', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91028', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91029', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91030', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91031', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91032', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91033', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91034', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91035', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91045', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tawau', '91056', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tenom', '89900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tenom', '89907', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tenom', '89908', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tenom', '89909', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tuaran', '89200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tuaran', '89207', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tuaran', '89208', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sabah', 'Tuaran', '89209', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Asajaya', '94600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Balingian', '96350', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Baram', '98050', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Baram', '98057', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Baram', '98058', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Baram', '98059', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bau', '94000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bau', '94007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bau', '94009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bekenu', '98150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bekenu', '98157', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bekenu', '98159', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Belaga', '96900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Belaga', '96950', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Belaga', '96999', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Belawai', '96150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Betong', '95700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Betong', '95707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Betong', '95709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintangor', '96500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintangor', '96507', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintangor', '96508', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintangor', '96509', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintangor', '96510', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97004', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97010', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97011', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97012', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97013', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97014', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97015', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Bintulu', '97300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Dalat', '96300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Dalat', '96307', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Dalat', '96309', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Daro', '96200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Debak', '95500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Engkilili', '95800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Julau', '96600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kabong', '94650', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kanowit', '96700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kanowit', '96707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kanowit', '96709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kapit', '96800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kapit', '96807', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kapit', '96809', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kota Samarahan', '94300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93010', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93030', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93050', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93150', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93250', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93350', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93400', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93450', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93502', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93503', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93504', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93505', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93506', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93507', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93508', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93514', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93516', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93517', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93518', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93519', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93520', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93527', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93529', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93532', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93540', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93550', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93551', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93552', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93554', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93556', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93558', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93560', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93564', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93566', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93570', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93572', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93576', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93578', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93582', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93586', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93590', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93592', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93594', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93596', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93604', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93606', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93608', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93609', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93610', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93612', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93614', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93618', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93619', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93620', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93626', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93628', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93632', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93634', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93648', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93658', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93660', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93661', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93662', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93668', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93670', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93672', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93677', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93690', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93694', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93702', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93704', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93706', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93708', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93710', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93712', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93714', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93716', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93718', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93720', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93722', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93724', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93726', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93728', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93730', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93732', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93734', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93736', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93738', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93740', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93742', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93744', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93746', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93748', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93750', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93752', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93754', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93756', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93758', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93760', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93762', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93764', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93902', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93904', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93906', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93908', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93910', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93912', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93914', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93916', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Kuching', '93990', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lawas', '98850', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lawas', '98857', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lawas', '98859', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Limbang', '98700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Limbang', '98707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Limbang', '98708', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Limbang', '98709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lingga', '94900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Long Lama', '98300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lubok Antu', '95900', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lundu', '94500', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lundu', '94507', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lundu', '94509', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lutong', '98100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lutong', '98107', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Lutong', '98109', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Matu', '96250', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Miri', '98000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Miri', '98007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Miri', '98008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Miri', '98009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Mukah', '96400', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Mukah', '96410', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Nanga Medamit', '98750', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Niah', '98200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Pusa', '94950', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Pusat Mel Miri', '98070', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Roban', '95300', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Saratok', '95400', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Saratok', '95407', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Saratok', '95409', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sarikei', '96100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sarikei', '96107', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sarikei', '96108', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sarikei', '96109', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sebauh', '97100', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sebuyau', '94850', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Serian', '94700', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Serian', '94707', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Serian', '94709', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Serian', '94750', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Serian', '94760', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sibu', '96000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sibu', '96007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sibu', '96008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sibu', '96009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sibu Jaya', '96010', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Siburan', '94200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Simunjan', '94800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Simunjan', '94807', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Simunjan', '94809', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Song', '96850', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Spaoh', '95600', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sri Aman', '95000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sri Aman', '95007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sri Aman', '95008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sri Aman', '95009', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Sundar', '98800', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Sarawak', 'Tatau', '97200', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Ampang', '68000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Bandar Baru Bangi', '43650', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Bandar Puncak Alam', '42300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Bangi', '43600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Banting', '42700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Berjuntai', '45600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Berjuntai', '45607', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Berjuntai', '45609', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Berjuntai', '45620', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Berjuntai', '45630', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Kali', '44300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Kali', '44309', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batang Kali', '44330', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Batu Caves', '68100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Beranang', '43700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Beranang', '43701', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Bukit Rotan', '45700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cheras', '43200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cheras', '43207', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cyberjaya', '63000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cyberjaya', '63100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cyberjaya', '63200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Cyberjaya', '63300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Dengkil', '43800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Dengkil', '43807', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Hulu Langat', '43100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Jenjarom', '42600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Jenjarom', '42610', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Jenjarom', '42619', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Jeram', '45800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kajang', '43000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kajang', '43007', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kajang', '43009', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kajang', '43558', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kapar', '42200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kapar', '42209', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kerling', '44100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41070', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41160', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41205', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41250', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41299', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41301', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41506', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41560', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41586', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41670', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41672', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41710', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41720', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41730', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41750', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41780', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41902', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41904', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41906', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41908', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41910', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41912', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41914', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41916', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41918', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '41990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '42100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Klang', '42150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'KLIA', '64000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Kubu Baru', '44000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Kubu Baru', '44010', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Kubu Baru', '44020', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Kubu Baru', '44110', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Selangor', '45000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Kuala Selangor', '45010', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pelabuhan Klang', '42000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pelabuhan Klang', '42007', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pelabuhan Klang', '42008', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pelabuhan Klang', '42009', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46040', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46080', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46160', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46350', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46460', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46505', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46506', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46510', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46547', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46549', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46551', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46564', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46582', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46598', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46662', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46667', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46668', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46672', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46675', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46692', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46710', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46720', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46730', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46740', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46750', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46760', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46770', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46780', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46781', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46782', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46783', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46784', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46785', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46786', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46787', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46788', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46789', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46790', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46791', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46792', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46793', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46794', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46795', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46796', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46797', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46798', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46799', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46801', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46802', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46803', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46804', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46805', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46806', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46860', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46870', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46960', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46962', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46964', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46966', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46968', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46970', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46972', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46974', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46976', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46978', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '46990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47301', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47304', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47307', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47308', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47309', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47310', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47410', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47430', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47801', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47810', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47820', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47829', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47830', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Petaling Jaya', '47850', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47110', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47120', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47130', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47140', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47160', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47170', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47180', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Puchong', '47190', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Carey', '42960', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Carey', '42999', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Indah', '42900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Indah', '42907', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Indah', '42920', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Pulau Ketam', '42940', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rasa', '44200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48009', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48010', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48020', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Rawang', '48302', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sabak Bernam', '45200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sabak Bernam', '45207', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sabak Bernam', '45209', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sekinchan', '45400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Semenyih', '43500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sepang', '43900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Serdang', '43400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Serendah', '48200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Serendah', '48250', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Seri Kembangan', '43300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Seri Kembangan', '43399', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40140', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40160', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40169', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40170', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40179', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40250', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40350', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40400', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40409', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40410', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40440', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40450', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40460', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40470', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40490', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40502', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40503', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40505', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40512', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40517', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40520', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40529', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40542', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40548', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40550', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40551', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40560', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40564', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40570', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40572', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40576', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40578', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40582', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40590', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40592', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40594', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40596', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40598', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40604', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40607', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40608', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40610', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40612', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40620', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40622', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40626', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40630', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40632', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40646', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40648', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40650', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40660', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40664', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40670', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40672', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40673', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40674', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40675', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40676', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40680', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40690', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40700', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40702', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40704', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40706', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40708', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40710', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40712', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40714', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40716', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40718', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40720', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40722', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40724', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40726', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40728', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40730', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40732', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40802', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40804', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40806', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40808', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40810', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40900', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40912', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40915', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '40990', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Shah Alam', '42450', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Airport', '47200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Airport', '47210', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47507', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47510', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47600', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47601', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47610', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47618', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47620', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47630', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47640', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '47650', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Subang Jaya', '55555', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Ayer Tawar', '45100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Besar', '45300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Buloh', '47000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Buloh', '47020', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Buloh', '47031', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Pelek', '43950', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Sungai Pelek', '43999', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Tanjong Karang', '45500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Tanjong Sepat', '42800', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Telok Panglima Garang', '42425', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Telok Panglima Garang', '42500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Telok Panglima Garang', '42507', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Selangor', 'Telok Panglima Garang', '42509', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ajil', '21800', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ajil', '21810', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ajil', '21820', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Al Muktatfi Billah Shah', '23400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ayer Puteh', '24050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Bukit Besi', '23200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Bukit Payong', '21400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ceneh', '24060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Chalok', '21450', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Cukai', '24040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Dungun', '23000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Dungun', '23007', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Dungun', '23009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Dungun', '23050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Jerteh', '22000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Jerteh', '22010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Jerteh', '22020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Jerteh', '22030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Jerteh', '22040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kampung Raja', '22200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kemasek', '24200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kemasek', '24207', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kemasek', '24209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kemasek', '24210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kemasek', '24220', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kerteh', '24300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ketengah Jaya', '23300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Ketengah Jaya', '23345', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kijal', '24100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kijal', '24107', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kijal', '24109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Berang', '21700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Besut', '22300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Besut', '22307', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Besut', '22309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20400', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20502', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20503', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20504', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20505', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20506', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20508', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20512', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20514', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20516', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20517', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20518', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20519', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20520', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20532', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20534', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20536', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20538', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20540', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20542', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20546', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20548', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20550', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20551', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20552', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20554', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20556', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20560', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20564', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20566', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20568', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20570', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20572', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20576', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20578', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20582', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20586', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20590', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20592', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20596', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20604', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20606', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20608', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20609', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20612', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20614', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20618', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20620', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20622', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20626', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20628', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20630', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20632', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20646', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20648', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20656', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20658', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20660', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20661', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20662', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20664', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20668', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20670', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20672', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20673', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20674', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20676', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20680', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20690', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20698', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20700', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20710', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20720', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20900', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20902', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20904', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20906', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20908', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20910', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20912', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20914', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20916', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20918', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20920', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20922', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20924', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20926', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20928', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20930', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20990', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '20999', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21000', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21009', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21010', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21020', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21030', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21040', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21050', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21060', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21070', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21080', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21090', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21200', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21209', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21210', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21220', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21300', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Kuala Terengganu', '21309', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Marang', '21600', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Marang', '21610', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Paka', '23100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Permaisuri', '22100', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Permaisuri', '22107', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Permaisuri', '22109', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Permaisuri', '22110', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Permaisuri', '22120', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Terengganu', 'Sungai Tong', '21500', '2', '3', '5');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87000', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87007', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87008', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87010', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87011', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87012', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87013', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87014', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87015', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87016', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87017', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87018', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87019', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87020', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87021', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87022', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87023', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87024', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87025', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87026', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87027', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87028', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87029', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87030', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87031', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87032', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Labuan', 'Labuan', '87033', '4', '5', '7');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62000', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62007', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62050', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62052', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62100', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62150', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62200', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62250', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62300', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62500', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62502', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62503', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62504', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62505', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62506', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62510', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62512', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62514', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62516', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62517', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62518', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62519', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62520', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62522', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62524', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62526', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62527', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62529', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62530', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62532', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62536', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62539', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62540', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62542', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62546', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62550', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62551', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62570', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62574', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62576', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62578', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62582', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62584', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62590', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62592', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62594', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62596', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62602', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62604', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62605', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62606', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62616', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62618', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62620', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62623', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62624', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62628', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62630', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62632', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62648', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62652', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62654', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62657', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62662', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62668', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62670', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62674', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62675', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62676', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62677', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62686', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62690', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62692', '1', '1', '3');
INSERT INTO `postcode` (`state`, `city`, `postcode`, `zone`, `sla_min_days`, `sla_max_days`) VALUES ('Wp Putrajaya', 'Putrajaya', '62988', '1', '1', '3');